#if !BLOCK_X
    #define BLOCK_X 16
#endif
#if !BLOCK_Y
    #define BLOCK_Y BLOCK_X
#endif

cbuffer CB : register(b0)
{
        uint SrcWidth;
        uint SrcHeight;
        uint RotateType;
};
// 0:clockwise 90;
// 1:clockwise 180;
// 2:clockwise 270;
// 3:flip Y;
// 4:flip X;
// 5:flip X && Y
RWTexture2D<float> outputTextureY : register(u0);
RWTexture2D<float2> outputTextureUV : register(u1);
Texture2D<float> inputTextureY : register(t0);
Texture2D<float2> inputTextureUV : register(t1);

[numthreads(BLOCK_X, BLOCK_Y, 1)] void CSMain(uint3 Gid : SV_GroupID,
                                                uint3 DTid : SV_DispatchThreadID,
                                                uint3 GTid : SV_GroupThreadID,
                                                uint GI : SV_GroupIndex)
{
        uint2 Coord = uint2(SrcWidth,SrcHeight);
        switch (RotateType)
        {
        case (0):
                Coord = uint2(DTid.y,SrcHeight-1 - DTid.x);
                break;
        case (1):
                Coord = uint2(SrcWidth -1 - DTid.x, SrcHeight -1 - DTid.y);
                break;
        case (2):
                Coord = uint2(SrcWidth-1 - DTid.y, DTid.x);
                break;
        case (3):
                Coord = uint2(SrcWidth-1 - DTid.x, DTid.y);
                break;
        case (4):
                Coord = uint2(DTid.x, SrcHeight-1 - DTid.y);
                break;
        case (5):
                Coord = uint2(SrcWidth-1 - DTid.x, SrcHeight-1 - DTid.y);
                break;
        default:
                Coord = uint2(DTid.y,SrcHeight-1 - DTid.x);
                break;
        }
        outputTextureY[DTid.xy] = inputTextureY[Coord.xy];
        if (DTid.x % 2 == 0 && DTid.y % 2 == 0)
        {
                outputTextureUV[DTid.xy / 2] = inputTextureUV[Coord.xy / 2];
        }
}